/*
 * navigation.h
 *
 *  Created on: Apr 8, 2015
 *      Author: Jordan
 */

#ifndef USER_CODE_NAVIGATION_H_
#define USER_CODE_NAVIGATION_H_

#define PI 3.141592653

#define INIT_SAMPLE_LENGTH 30

#define EKF_DEBUG 0
#define SENSOR_DEBUG 0
#define SENSOR_USE_RAW 0
#define EULER_DEBUG 0

#define ACC_X_OFFSET -0.005735667107001
#define ACC_Y_OFFSET -0.011259114927345
#define ACC_Z_OFFSET 0.021485468956409

#define GYRO_X_OFFSET -0.022234280052840
#define GYRO_Y_OFFSET -0.019190026420079
#define GYRO_Z_OFFSET -0.007389167767503

#define MAG_X_OFFSET -0.024262270089074
#define MAG_Y_OFFSET -0.044349719679356
#define MAG_Z_OFFSET 0.019190120813796
#define MAG_X_SCALE 1.892734034479687
#define MAG_Y_SCALE 2.037822280495056
#define MAG_Z_SCALE 2.252553646676796

uint8 get_INS_enabled();
void AHRS_init();
void INS_init();
void navigation_step();
float32 get_roll();
float32 get_pitch();
float32 get_yaw();
float32 get_roll_rate();
float32 get_pitch_rate();
float32 get_yaw_rate();
float32 get_NED_x();
float32 get_NED_y();
float32 get_NED_z();
float32 get_NED_x_dot();
float32 get_NED_y_dot();
float32 get_NED_z_dot();
float32 get_INS_lat();
float32 get_INS_lon();
float32 get_nav_x_dot();
float32 get_nav_y_dot();
float32 get_wpt_x(float32 lat);
float32 get_wpt_y(float32 lat, float32 lon);

#endif /* USER_CODE_NAVIGATION_H_ */
